package ru.yandex.direct.web.entity.uac.model

import java.math.BigDecimal
import ru.yandex.direct.core.entity.uac.model.DeviceType
import ru.yandex.direct.core.entity.uac.model.InventoryType
import ru.yandex.direct.core.entity.uac.model.LimitPeriodType
import ru.yandex.direct.core.entity.uac.model.AltAppStore
import ru.yandex.direct.core.entity.uac.model.Sitelink
import ru.yandex.direct.core.entity.uac.model.Socdem
import ru.yandex.direct.core.entity.uac.model.TargetStatus
import ru.yandex.direct.core.entity.uac.model.TargetType
import ru.yandex.direct.core.entity.uac.model.TimeTarget
import ru.yandex.direct.core.entity.uac.model.UacAdjustmentRequest
import ru.yandex.direct.core.entity.uac.model.UacFeedFilter
import ru.yandex.direct.core.entity.uac.model.UacGoal
import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.core.entity.uac.model.UacShowsFrequencyLimit
import ru.yandex.direct.core.entity.uac.model.UacStrategy
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform
import ru.yandex.direct.core.entity.uac.model.relevance_match.UacRelevanceMatch
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacBrandsafety
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCampaignMeasurer
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCpmAsset
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacDisabledPlaces
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacSearchLift

/**
 * Параметры для обновления кампании.
 * Отличается от [PatchCampaignRequest] тем, что может хранить параметры, неизвестные фронтенду.
 * И тут могут отсутствовать параметры, которые не относятся к кампании напрямую
 */
data class PatchCampaignInternalRequest(
    val displayName: String?,
    val href: String?,
    val appId: String?,
    val texts: List<String>?,
    val titles: List<String>?,
    val regions: List<Long>?,
    val minusRegions: List<Long>?,
    val contentIds: List<String>?,
    val trackingUrl: String?,
    val impressionUrl: String?,
    val targetId: TargetType?,
    val cpa: BigDecimal?,
    val crr: Long?,
    val weekLimit: BigDecimal?,
    val adultContentEnabled: Boolean?,
    val limitPeriod: LimitPeriodType?,
    val hyperGeoId: Long?,
    val keywords: List<String>?,
    val minusKeywords: List<String>?,
    val socdem: Socdem?,
    val deviceTypes: Set<DeviceType>?,
    val inventoryTypes: Set<InventoryType>?,
    val goals: List<UacGoal>?,
    val counters: List<Int>?,
    val permalinkId: Long?,
    val phoneId: Long?,
    val sitelinks: List<Sitelink>?,
    val targetStatus: TargetStatus?,
    val timeTarget: TimeTarget?,
    val strategy: UacStrategy?,
    val retargetingCondition: UacRetargetingCondition?,
    val videosAreNonSkippable: Boolean?,
    val zenPublisherId: String?,
    val brandSurveyId: String?,
    val brandSurveyName: String?,
    val showsFrequencyLimit: UacShowsFrequencyLimit?,
    val strategyPlatform: UacStrategyPlatform?,
    val adjustments: List<UacAdjustmentRequest>?,
    val isEcom: Boolean?,
    val feedId: Long?,
    val feedFilters: List<UacFeedFilter>?,
    val trackingParams: String?,
    val cpmAssets: Map<String, UacCpmAsset>?,
    val campaignMeasurers: List<UacCampaignMeasurer>?,
    val uacBrandsafety: UacBrandsafety?,
    val uacDisabledPlaces: UacDisabledPlaces?,
    // эти две галки могут быть сброшены при обработке запроса
    var isRecommendationsManagementEnabled: Boolean?,
    var isPriceRecommendationsManagementEnabled: Boolean?,

    val calltrackingSettingsId: Long?,
    val relevanceMatch: UacRelevanceMatch?,
    val showTitleAndBody: Boolean?,
    val altAppStores: Set<AltAppStore>?,
    val bizLandingId: Long?,
    val searchLift: UacSearchLift?,
)
