package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.model.TargetType
import ru.yandex.direct.core.entity.uac.model.UacStrategyName
import ru.yandex.direct.web.entity.SuccessResponse

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class UacAvailableStrategySettings (
    // Список доступных значений для payForConversion поля при создании компании
    // True - доступна fix стратегия
    // False - доступна avg стратегия
    val payForConversion: Set<Boolean?>
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class UacAvailableStrategyGoals(
    val goals: Map<TargetType, Set<UacStrategyName>>,
    val strategiesDataSettings: Map<UacStrategyName, UacAvailableStrategySettings> = STRATEGIES_DATA_SETTINGS
) {
    companion object {
        val STRATEGIES_DATA_SETTINGS = mapOf(
            UacStrategyName.AUTOBUDGET_AVG_CLICK to UacAvailableStrategySettings(setOf(false)),
            UacStrategyName.AUTOBUDGET_AVG_CPA to UacAvailableStrategySettings(setOf(false, true)),
            UacStrategyName.AUTOBUDGET_AVG_CPI to UacAvailableStrategySettings(setOf(false, true)),
            UacStrategyName.AUTOBUDGET_CRR to UacAvailableStrategySettings(setOf(false, true))
        )
    }
}

data class UacAvailableStrategyGoalsResponse(
    val reqId: String,
): SuccessResponse<UacAvailableStrategyGoals>()

