package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.moderationdiag.model.ModerationDiagData
import ru.yandex.direct.core.entity.uac.model.CampaignContentStatus
import ru.yandex.direct.core.entity.uac.model.Content
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.Sitelink
import ru.yandex.direct.core.entity.uac.model.campaign_content.ContentEfficiency

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class UacContentStatistics(
    val id: String,
    val content: Content?,
    val rejectReasons: List<ModerationDiagData>?,
    val text: String?,
    val contentType: MediaType,
    val status: CampaignContentStatus,
    val efficiency: ContentEfficiency?,
    val startedAt: Long,
    val deletedAt: Long?,
    val partialExistence: Boolean?,
    val sitelink: Sitelink?,
    val creativeStatistics: CreativeStatistics?,
    val bannerId: String?,
    val bid: String?,
)
