package ru.yandex.direct.web.entity.uac.model

import java.math.BigDecimal
import java.time.LocalDateTime
import ru.yandex.direct.core.entity.campaign.model.CampaignSource
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.AppInfo
import ru.yandex.direct.core.entity.uac.model.DeviceType
import ru.yandex.direct.core.entity.uac.model.InventoryType
import ru.yandex.direct.core.entity.uac.model.LimitPeriodType
import ru.yandex.direct.core.entity.uac.model.AltAppStore
import ru.yandex.direct.core.entity.uac.model.Sitelink
import ru.yandex.direct.core.entity.uac.model.Socdem
import ru.yandex.direct.core.entity.uac.model.TargetStatus
import ru.yandex.direct.core.entity.uac.model.TargetType
import ru.yandex.direct.core.entity.uac.model.TimeTarget
import ru.yandex.direct.core.entity.uac.model.TrackingUrl
import ru.yandex.direct.core.entity.uac.model.UacAdjustmentRequest
import ru.yandex.direct.core.entity.uac.model.UacFeedFilter
import ru.yandex.direct.core.entity.uac.model.UacGoal
import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.core.entity.uac.model.UacShowsFrequencyLimit
import ru.yandex.direct.core.entity.uac.model.UacStrategy
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform
import ru.yandex.direct.core.entity.uac.model.relevance_match.UacRelevanceMatch
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacBrandsafety
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCampaignMeasurer
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacCpmAsset
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacDisabledPlaces
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacSearchLift

data class UacModifyCampaignDataContainer(
    val id: String,
    val displayName: String,
    val advType: AdvType,
    val appInfo: AppInfo?,
    val texts: List<String>?,
    val titles: List<String>?,
    val regions: List<Long>?,
    val minusRegions: List<Long>?,
    val trackingUrl: TrackingUrl?,
    val impressionUrl: TrackingUrl?,
    val href: String,
    val targetId: TargetType?,
    val cpa: BigDecimal?,
    val crr: Long?,
    val weekLimit: BigDecimal?,
    val createdTime: LocalDateTime,
    val updatedTime: LocalDateTime,
    val startedTime: LocalDateTime?,
    val targetStatus: TargetStatus,
    val contentFlags: Map<String, Any>?,
    val limitPeriod: LimitPeriodType?,
    val skadNetworkEnabled: Boolean?,
    val adultContentEnabled: Boolean?,
    val hyperGeoId: Long?,
    val keywords: List<String>?,
    val minusKeywords: List<String>?,
    val socdem: Socdem?,
    val deviceTypes: Set<DeviceType>?,
    val inventoryTypes: Set<InventoryType>?,
    val goals: List<UacGoal>?,
    val counters: List<Int>?,
    val permalinkId: Long?,
    val phoneId: Long?,
    val calltrackingSettingsId: Long?,
    val sitelinks: List<Sitelink>?,
    val timeTarget: TimeTarget?,
    val strategy: UacStrategy?,
    val retargetingCondition: UacRetargetingCondition?,
    val videosAreNonSkippable: Boolean?,
    val zenPublisherId: String?,
    val brandSurveyId: String?,
    val brandSurveyName: String?,
    val showsFrequencyLimit: UacShowsFrequencyLimit?,
    val strategyPlatform: UacStrategyPlatform?,
    val adjustments: List<UacAdjustmentRequest>?,
    val isEcom: Boolean?,
    val feedId: Long?,
    val feedFilters: List<UacFeedFilter>?,
    val trackingParams: String?,
    val cpmAssets: Map<String, UacCpmAsset>?,
    val campaignMeasurers: List<UacCampaignMeasurer>?,
    val uacBrandsafety: UacBrandsafety?,
    val uacDisabledPlaces: UacDisabledPlaces?,
    val widgetPartnerId: Long?,
    val source: CampaignSource?,
    val mobileAppId: Long?,
    val isRecommendationsManagementEnabled: Boolean?,
    val isPriceRecommendationsManagementEnabled: Boolean?,
    val relevanceMatch: UacRelevanceMatch?,
    val showTitleAndBody: Boolean?,
    val altAppStores: Set<AltAppStore>?,
    val bizLandingId: Long?,
    val useCurrentRegion: Boolean?,
    val useRegularRegion: Boolean?,
    val searchLift: UacSearchLift?,
    val adGroupBriefRequests: List<UacAdGroupBriefRequest>? = null,
)
