package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import com.fasterxml.jackson.databind.annotation.JsonSerialize
import com.google.protobuf.Message
import ru.yandex.direct.web.common.converter.protojson.ProtobufSerializer
import ru.yandex.direct.web.entity.SuccessResponse

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
open class UacProtoResponse<T : Message>(val reqId: String, result: T) : SuccessResponse<T>(result) {

    @JsonSerialize(using = ProtobufSerializer::class)
    override fun getResult(): T? {
        return super.getResult()
    }
}
