package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming


class SaasKeyNames {
    companion object {
        val DATABASE_ID: String = "s_database_id"
    }
}

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
data class SaasResponse(
    val grouping: List<Grouping>?,
)

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
data class Grouping(
    val group: List<Group>?,
)

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
data class Group(
    val document: List<Document>?,
)

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
data class Document(
    val archiveInfo: ArchiveInfo,
    val relevance: Int,
)

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
data class ArchiveInfo(
    val gtaRelatedAttribute: List<GtaRelatedAttribute>,
)

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
data class GtaRelatedAttribute(
    val key: String,
    val value: String,
)
