package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.annotation.JsonIgnore
import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.model.TrackingSystem
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils
import ru.yandex.direct.web.entity.SuccessResponse
import java.time.LocalDateTime

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class LastCampaignInfo(
    val id: Long,
    val name: String,
    @JsonIgnore
    val createdTime: LocalDateTime,
) {
    @get:JsonProperty
    private val createdAt: String
        get() = UacYdbUtils.toEpochSecond(createdTime).toString()
}

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class UacTrackingInfo(
    val trackingUrl: String?,
    val impressionUrl: String?,
    val trackerName: TrackingSystem?,
    val lastCampaignInfo: LastCampaignInfo,
)

@JsonNaming(PropertyNamingStrategy.UpperCamelCaseStrategy::class)
class UacTrackingInfoResponse (
    val reqId: String,
): SuccessResponse<List<UacTrackingInfo>>()
