package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.annotation.JsonValue
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
class ValidateTrackingUrlRequest(
    val url: String,
    val validationType: ValidationType,
    val appInfoId: String?,
    val appId: String?,
)

enum class ValidationType {
    REDIRECT_URL,
    TRACKING_URL,
    IMPRESSION_URL,
    ;

    @JsonValue
    open fun getType() = name.lowercase()
}
