package ru.yandex.direct.web.entity.uac.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.model.Parameter
import ru.yandex.direct.core.entity.uac.model.Platform
import ru.yandex.direct.core.entity.uac.model.TrackingSystem
import ru.yandex.direct.core.entity.uac.model.TrackingUrl

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class ParameterResponse(
    val name: String,
    val value: String?,
    val osType: String?,
    val required: Boolean,
    val description: String?
) {
    companion object {
        fun fromParameter(parameter: Parameter): ParameterResponse {
            return ParameterResponse(
                name = parameter.name,
                value = if (parameter.overwrite) parameter.value else null,
                osType = parameter.platform?.name?.lowercase(),
                required = parameter.required,
                description = parameter.description,
            )
        }
    }
}

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class ValidatedTrackingUrl(
    val url: String,
    val skadNetworkIntegrated: Boolean,
    val system: TrackingSystem,
    val hasImpression: Boolean,
    val parameters: List<ParameterResponse>,
    val trackerId: String?,
) {
    companion object {
        fun fromTrackingUrl(trackingUrl: TrackingUrl): ValidatedTrackingUrl {
            return ValidatedTrackingUrl(
                url = trackingUrl.getUrl(),
                skadNetworkIntegrated = trackingUrl.skadNetworkIntegrated,
                system = trackingUrl.system,
                hasImpression = trackingUrl.hasImpression,
                parameters = trackingUrl.parameters.map {ParameterResponse.fromParameter(it)}.toList(),
                trackerId = trackingUrl.trackerId,
            )
        }
    }
}
