package ru.yandex.direct.web.entity.uac.model.history.event

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import java.time.LocalDateTime
import ru.yandex.direct.core.entity.uac.model.CampaignContentStatus
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaignContent
import ru.yandex.direct.web.entity.uac.model.history.GrutHistoryOutputCategory

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GrutSitelinkView(
    val title: String,
    val href: String,
    val description: String?
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GrutAssetLinkHistoryView(
    val id: String,
    val contentId: String?,
    val order: Int,
    val createdAt: LocalDateTime,
    val removedAt: LocalDateTime?,
    val status: CampaignContentStatus,
    val sitelink: GrutSitelinkView? = null,
)

fun toGrutAssetLinkHistoryView(asset: UacYdbCampaignContent): GrutAssetLinkHistoryView {
    return GrutAssetLinkHistoryView(
        asset.id,
        asset.contentId,
        asset.order,
        asset.createdAt,
        asset.removedAt,
        asset.status,
        asset.sitelink
            ?.let {
                GrutSitelinkView(
                    it.title,
                    it.href,
                    it.description,
                )
            }
    )
}
