package ru.yandex.direct.web.entity.uac.model.history.event

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import java.math.BigDecimal
import java.time.LocalDate
import ru.yandex.direct.core.entity.uac.model.TargetType
import ru.yandex.direct.core.entity.uac.model.UacStrategyName
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GrutGoalView(
    val goalId: Long,
    val conversionValue: BigDecimal?
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GrutStrategyView(
    val strategyName: UacStrategyName,
    val strategyData: GrutStrategyDataView,
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GrutStrategyDataView(
    val budget: BigDecimal?,
    val autoProlongation: Boolean?,
    val avgCpm: BigDecimal?,
    val finishDate: LocalDate?,
    val startDate: LocalDate?,
    val sum: BigDecimal?,
    val avgCpv: BigDecimal?,
    val crr: Long?,
    val avgCpa: BigDecimal?,
    val avgCpi: BigDecimal?,
    val avgBid: BigDecimal?,
    val payForConversion: Boolean?,
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class GrutStrategyOptionsHistoryView(
    val strategy: GrutStrategyView?,
    val goals: List<GrutGoalView>,
    val strategyPlatform: UacStrategyPlatform?,
    val targetId: TargetType?,
    val weekLimit: BigDecimal?,
    val cpa: BigDecimal?,
)
