package ru.yandex.direct.web.entity.uac.model.links

import com.fasterxml.jackson.annotation.JsonProperty
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.core.entity.uac.model.AppInfo
import ru.yandex.direct.core.entity.uac.model.MarketplaceInfo
import ru.yandex.direct.result.Result

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class LinkInfo(
        @JsonProperty("ecom") val isEcom: Boolean,
        @JsonProperty("marketplace") val isMarketplace: Boolean,
        @JsonProperty("zen") val isZen: Boolean,
        val marketplaceInfo: MarketplaceInfo?,
        val appInfo: AppInfo?
) {
    constructor(isZen: Boolean, appInfo: AppInfo?): this(false, false, isZen, null, appInfo)
}

fun LinkInfo.successfulResult(): Result<LinkInfo> = Result.successful(this)
