package ru.yandex.direct.web.entity.uac.operation

import ru.yandex.direct.core.entity.uac.operation.UacUploadImageByUrlToAvatarsOperation
import ru.yandex.direct.core.entity.uac.service.UacAvatarsService
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.web.entity.uac.validation.UacAvatarsUrlValidator

class UacUploadImageByThumbToAvatarsOperation(
        private val uacAvatarsService: UacAvatarsService,
        private val url: String
): UacUploadImageByUrlToAvatarsOperation(uacAvatarsService, url) {
    private val uacAvatarsUrlValidator = UacAvatarsUrlValidator(
        listOf("google-play-app-screens", "itunes-screens", "rmp_stores_data"),
        listOf("orig"),
    )

    override fun prepare(): ValidationResult<String, Defect<*>> {
        return validateObject(url) {
            check(uacAvatarsUrlValidator::validate)
        }
    }
}
