package ru.yandex.direct.web.entity.uac.operation

import ru.yandex.direct.core.entity.uac.model.UacAvatarsResponseInfo
import ru.yandex.direct.core.entity.uac.operation.CheckableOperation
import ru.yandex.direct.core.entity.uac.service.UacAvatarsService
import ru.yandex.direct.result.Result
import ru.yandex.direct.validation.defect.CollectionDefects
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.check
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.web.entity.uac.service.UacConstants

class UacUploadImageToAvatarsOperation(
    private val uacAvatarsService: UacAvatarsService,
    private val image: ByteArray
): CheckableOperation<ByteArray, UacAvatarsResponseInfo>() {

    override fun prepare(): ValidationResult<ByteArray, Defect<*>> {
        return validateObject(image) {
            check(CollectionDefects.maxElementsExceeded(UacConstants.IMAGE_MAX_FILE_SIZE)) {
                it.size <= UacConstants.IMAGE_MAX_FILE_SIZE
            }
        }
    }

    override fun apply(): Result<UacAvatarsResponseInfo> {
        return uacAvatarsService.uploadImage(image, null)
    }
}
