package ru.yandex.direct.web.entity.uac.service

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.service.UacDbDefineService
import ru.yandex.direct.dbutil.model.ClientId

@Component
class UacCampaignWebServiceHolder(
    private val uacDbDefineService: UacDbDefineService,
    private val ydbUacCampaignAddService: YdbUacCampaignAddService,
    private val grutUacCampaignAddService: GrutUacCampaignAddService,
    private val webYdbUacCampaignUpdateService: WebYdbUacCampaignUpdateService,
    private val webGrutUacCampaignUpdateService: WebGrutUacCampaignUpdateService,
    private val ydbUacCampaignWebService: YdbUacCampaignWebService,
    private val grutUacCampaignWebService: GrutUacCampaignWebService,
    private val ydbUacContentWebService: YdbUacContentWebService,
    private val grutUacContentWebService: GrutUacContentWebService,
) {

    fun getUacCampaignWebService(campaignId: String) =
        getUacCampaignWebService(uacDbDefineService.useGrut(campaignId))

    fun getUacCampaignWebService(clientId: ClientId, advType: AdvType) =
        getUacCampaignWebService(uacDbDefineService.useGrutForNewCampaign(clientId, advType))

    fun getUacCampaignWebService(useGrut: Boolean) =
        if (useGrut) grutUacCampaignWebService
        else ydbUacCampaignWebService

    fun getUacCampaignAddService(clientId: ClientId, advType: AdvType) =
        getUacCampaignAddService(uacDbDefineService.useGrutForNewCampaign(clientId, advType))

    fun getUacCampaignAddService(useGrut: Boolean) =
        if (useGrut) grutUacCampaignAddService
        else ydbUacCampaignAddService

    fun getUacCampaignUpdateService(campaignId: String) =
        getUacCampaignUpdateService(uacDbDefineService.useGrut(campaignId))

    fun getUacCampaignUpdateService(useGrut: Boolean) =
        if (useGrut) webGrutUacCampaignUpdateService
        else webYdbUacCampaignUpdateService

    fun getUacContentWebService(useGrut: Boolean) =
        if (useGrut) grutUacContentWebService
        else ydbUacContentWebService
}
