package ru.yandex.direct.web.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.repository.ydb.model.CpmAssetLogo
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.grid.core.entity.banner.model.GdiBannerLogo
import ru.yandex.direct.grid.core.entity.banner.repository.GridImageRepository
import ru.yandex.direct.web.entity.uac.model.UacModifyCampaignDataContainer

/**
 * Сервис для cpm продуктов
 */
@Service
class UacCpmBannerService(
    private val imageRepository: GridImageRepository,
    private val shardHelper: ShardHelper,
) {
    /**
     * Добавляет в cpm кампанию на обновлении специфичными системные поля
     */
    fun fillCampaign(
        clientId: ClientId,
        dataContainer: UacModifyCampaignDataContainer,
    ) {
        val imageHashes = dataContainer.cpmAssets?.values?.mapNotNull { it.logoImageHash } ?: emptyList()
        val logos = loadLogos(imageHashes, clientId)
        dataContainer.cpmAssets?.values?.forEach { it.logoImage = logos[it.logoImageHash]}
    }

    private fun loadLogos(imageHashes: List<String>,
                          clientId: ClientId): Map<String,CpmAssetLogo> {
        if (imageHashes.isEmpty()) {
            return emptyMap()
        }
        val dbRes = imageRepository.getBannerLogosByHash(shardHelper.getShardByClientId(clientId), clientId,imageHashes)
        return dbRes?.associateBy({it.imageHash}, this::convertToCpmAssetLogo)?:emptyMap()
    }

    private fun convertToCpmAssetLogo(gdiLogo: GdiBannerLogo):CpmAssetLogo {
        var x80 = gdiLogo.mdsMeta.sizes["x80"]
        return CpmAssetLogo(
            hash = gdiLogo.imageHash,
            height = x80?.height ?: 0,
            width = x80?.width ?: 0,
            name = gdiLogo.name,
            path = x80?.path ?: "",
            mdsGroupId = gdiLogo.mdsGroupId,
            namespace = gdiLogo.namespace.name,
        )
    }
}
