package ru.yandex.direct.web.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.image.container.BannerImageType
import ru.yandex.direct.core.entity.image.model.BannerImageSource
import ru.yandex.direct.core.entity.image.service.ImageService
import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.result.Result
import ru.yandex.direct.web.entity.uac.model.DirectImageInfo

@Service
class UacDirectImageUploader(
    private val imageService: ImageService
) {
    fun upload(subjectUser: User, url: String): Result<DirectImageInfo> {
        val operationResult = imageService.saveImageFromUrl(
            subjectUser.clientId, url, BannerImageType.BANNER_TEXT, BannerImageSource.UAC, null
        )
        if (!operationResult.isSuccessful) {
            return Result.broken(operationResult.validationResult)
        }
        val imageInformation = operationResult.result
        return Result.successful(
            DirectImageInfo(
                imageHash = imageInformation.imageHash,
                mdsMeta = imageInformation.mdsMeta,
                imageType = imageInformation.imageType
            )
        )
    }
}
