package ru.yandex.direct.web.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.geosuggest.client.GeoSuggestClient
import ru.yandex.direct.geosuggest.client.model.GeoSuggestResponse
import ru.yandex.direct.i18n.Language
import ru.yandex.direct.regions.GeoTreeFactory

@Service
class UacGeoSuggestService(
    private val geoSuggestClient: GeoSuggestClient,
    geoTreeFactory: GeoTreeFactory,
) {

    private val availableRegions = geoTreeFactory.apiGeoTree.regions.keys.minus(0)

    private fun findRegionsByText(
        text: String,
        lang: Language,
        limit: Int
    ): GeoSuggestResponse {
        return geoSuggestClient.getSuggestedRegions(
            limit = limit,
            clientId = "rmp.uac",
            basesTypes = "geobase_country,geobase_country_part,geobase_region,geobase_city",
            highlightMatching = false,
            responseVersion = 8,
            latLong = "37.588628,55.734046",
            lang = lang.langString,
            text = text,
        )
    }

    fun findAvailableRegionsByText(
        text: String,
        lang: Language,
        limit: Int
    ): GeoSuggestResponse {
        val regions = findRegionsByText(text, lang, limit)
        return regions
            .filter { availableRegions.contains(it.geoid) }
    }
}
