package ru.yandex.direct.web.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.common.db.PpcPropertiesSupport
import ru.yandex.direct.common.db.PpcProperty
import ru.yandex.direct.common.db.PpcPropertyNames
import java.time.Duration

@Service
class UacPropertiesService(
    private val ppcPropertiesSupport: PpcPropertiesSupport,
) {
    private val maxTextsInUacProperty: PpcProperty<Int> = ppcPropertiesSupport
        .get(PpcPropertyNames.MAX_TEXTS_IN_UAC, Duration.ofMinutes(5))
    private val maxTitlesInUacProperty: PpcProperty<Int> = ppcPropertiesSupport
        .get(PpcPropertyNames.MAX_TITLES_IN_UAC, Duration.ofMinutes(5))
    private val enableOrigThumbInUacProperty: PpcProperty<Boolean> = ppcPropertiesSupport
        .get(PpcPropertyNames.ENABLE_ORIG_THUMB_IN_UAC, Duration.ofMinutes(5))
    private val crrTrackerConversionsNumThreshold: PpcProperty<Long> = ppcPropertiesSupport
        .get(PpcPropertyNames.CRR_TRACKER_CONVERSIONS_NUM_THRESHOLD, Duration.ofMinutes(5))
    private val crrMobileAppConversionsNumThreshold: PpcProperty<Long> = ppcPropertiesSupport
        .get(PpcPropertyNames.CRR_MOBILE_APP_CONVERSIONS_NUM_THRESHOLD, Duration.ofMinutes(5))
    private val crrConversionsThresholdIntervalInDays: PpcProperty<Int> = ppcPropertiesSupport
        .get(PpcPropertyNames.CRR_CONVERSIONS_THRESHOLD_INTERVAL_IN_DAYS, Duration.ofMinutes(5))

    val maxTexts get() = maxTextsInUacProperty.getOrDefault(UacConstants.UAC_TEXTS_MAX_LENGTH)
    val maxTitles get() = maxTitlesInUacProperty.getOrDefault(UacConstants.UAC_TITLES_MAX_LENGTH)
    val enableOrigThumb get() = enableOrigThumbInUacProperty.getOrDefault(false)
    val crrTrackerThreshold get() =
        crrTrackerConversionsNumThreshold.getOrDefault(UacConstants.UAC_CONVERSIONS_CRR_THRESHOLD)
    val crrMobileAppThreshold get() =
        crrMobileAppConversionsNumThreshold.getOrDefault(UacConstants.UAC_CONVERSIONS_CRR_THRESHOLD)
    val crrDaysThreshold get() =
        crrConversionsThresholdIntervalInDays.getOrDefault(UacConstants.UAC_CONVERSIONS_CRR_DAYS)
}
