package ru.yandex.direct.web.entity.uac.service

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.adgroup.service.AdGroupService
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService
import ru.yandex.direct.core.entity.client.service.ClientGeoService
import ru.yandex.direct.core.entity.client.service.ClientLimitsService
import ru.yandex.direct.core.entity.client.service.ClientService
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.core.entity.feed.service.FeedService
import ru.yandex.direct.core.entity.image.repository.BannerImageFormatRepository
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterStorage
import ru.yandex.direct.core.entity.retargeting.service.validation2.AddRetargetingConditionValidationService2
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository
import ru.yandex.direct.core.entity.uac.converter.UacGrutAdGroupBriefConverter.toAdGroupBriefGrutModel
import ru.yandex.direct.core.entity.uac.converter.UacGrutCampaignConverter.toCampaignSpec
import ru.yandex.direct.core.entity.uac.model.DirectCampaignStatus
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbUtils.toIdLong
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.entity.uac.service.AudienceSegmentsService
import ru.yandex.direct.core.entity.uac.service.CpmBannerCampaignService
import ru.yandex.direct.core.entity.uac.service.GrutUacCampaignService
import ru.yandex.direct.core.entity.uac.service.GrutUacContentService
import ru.yandex.direct.core.entity.uac.service.RmpCampaignService
import ru.yandex.direct.core.entity.uac.service.UacBannerService
import ru.yandex.direct.core.entity.uac.service.UacCampaignsCoreService
import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.core.grut.replication.GrutApiService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.feature.FeatureName
import ru.yandex.direct.grid.processing.service.campaign.uc.UcCampaignMutationService
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler
import ru.yandex.direct.model.KtModelChanges
import ru.yandex.direct.result.Result
import ru.yandex.direct.web.entity.uac.model.PatchCampaignInternalRequest
import ru.yandex.grut.objects.proto.client.Schema
import ru.yandex.grut.objects.proto.client.Schema.TCampaignMeta

@Service
class WebGrutUacCampaignUpdateService(
    uacBannerService: UacBannerService,
    uacModifyCampaignDataContainerFactory: UacModifyCampaignDataContainerFactory,
    rmpCampaignService: RmpCampaignService,
    uacCampaignsCoreService: UacCampaignsCoreService,
    clientService: ClientService,
    ucCampaignMutationService: UcCampaignMutationService,
    uacCampaignValidationService: UacCampaignValidationService,
    uacGoalsService: UacGoalsService,
    clientGeoService: ClientGeoService,
    cpmBannerCampaignService: CpmBannerCampaignService,
    uacMobileAppService: UacMobileAppService,
    uacAdjustmentsUpdateService: UacAdjustmentsService,
    uacPropertiesService: UacPropertiesService,
    grutUacContentService: GrutUacContentService,
    baseUacCampaignService: GrutUacCampaignService,
    sspPlatformsRepository: SspPlatformsRepository,
    hostingsHandler: HostingsHandler,
    bannerImageFormatRepository: BannerImageFormatRepository,
    shardHelper: ShardHelper,
    cpmBannerService: UacCpmBannerService,
    clientLimitsService: ClientLimitsService,
    disableDomainValidationService: DisableDomainValidationService,
    rmpStrategyValidatorFactory: RmpStrategyValidatorFactory,
    retargetingConditionValidationService: AddRetargetingConditionValidationService2,
    audienceSegmentsService: AudienceSegmentsService,
    feedService: FeedService,
    filterSchemaStorage: PerformanceFilterStorage,
    private val grutApiService: GrutApiService,
    private val grutUacAssetLinkUpdateService: GrutUacAssetLinkUpdateService,
    private val featureService: FeatureService,
    private val adGroupService: AdGroupService,
) : WebBaseUacCampaignUpdateService(
    uacBannerService,
    uacMobileAppService,
    uacModifyCampaignDataContainerFactory,
    rmpCampaignService,
    uacCampaignsCoreService,
    clientService,
    ucCampaignMutationService,
    uacCampaignValidationService,
    uacGoalsService,
    clientGeoService,
    cpmBannerCampaignService,
    uacAdjustmentsUpdateService,
    grutUacContentService,
    uacPropertiesService,
    baseUacCampaignService,
    sspPlatformsRepository,
    hostingsHandler,
    bannerImageFormatRepository,
    shardHelper,
    cpmBannerService,
    clientLimitsService,
    disableDomainValidationService,
    rmpStrategyValidatorFactory,
    featureService,
    retargetingConditionValidationService,
    audienceSegmentsService,
    feedService,
    filterSchemaStorage,
) {

    companion object {
        private val logger = LoggerFactory.getLogger(WebGrutUacCampaignUpdateService::class.java)
    }

    override fun getLogger(): Logger = logger

    override fun updateBrief(
        updatedUacYdbCampaign: UacYdbCampaign,
        request: PatchCampaignInternalRequest,
        clientId: ClientId,
        multipleAdsInUc: Boolean,
    ): UacYdbCampaign {
        val newAssetLinkIdsGenerationEnabled =
            featureService.isEnabledForClientId(clientId, FeatureName.UC_UAC_NEW_ASSET_LINK_IDS_GENERATION_IN_GRUT)
        val fullyUpdatedUacYdbCampaign = updatedUacYdbCampaign.copy(
            assetLinks = grutUacAssetLinkUpdateService.getUpdatedAssetLinks(updatedUacYdbCampaign, request, clientId,
                newAssetLinkIdsGenerationEnabled)
        )

        val campaignId = updatedUacYdbCampaign.id.toIdLong()
        grutApiService.briefGrutApi.updateBriefFull(Schema.TCampaign.newBuilder().apply {
            meta = TCampaignMeta.newBuilder().setId(campaignId).build()
            spec = toCampaignSpec(fullyUpdatedUacYdbCampaign)
        }.build())

        if (featureService.isEnabledForClientId(clientId, FeatureName.UAC_MULTIPLE_AD_GROUPS_ENABLED)) {
            val adGroupBriefs = grutApiService.adGroupBriefGrutApi.selectAdGroupBriefsByCampaignId(campaignId)
            if (adGroupBriefs.isEmpty()) {
                val adGroupIds = adGroupService.getAdGroupIdsByCampaignIds(setOf(campaignId))[campaignId]
                val adGroupBriefGrutModel =
                    toAdGroupBriefGrutModel(campaignId, fullyUpdatedUacYdbCampaign, adGroupIds = adGroupIds)
                val adGroupBriefId = grutApiService.adGroupBriefGrutApi
                    .createAdGroupBriefs(listOf(adGroupBriefGrutModel))[0]
                logger.info("Existing ad group briefs not found by campaign $campaignId. " +
                    "Created a new ad group brief $adGroupBriefId with ad group ids $adGroupIds")
            } else if (adGroupBriefs.size == 1) {
                val adGroupBriefId = adGroupBriefs[0].id
                logger.info("Found one existing ad group brief by campaign $campaignId: $adGroupBriefId, updating")
                val adGroupBriefGrutModel = toAdGroupBriefGrutModel(
                    campaignId,
                    fullyUpdatedUacYdbCampaign,
                    id = adGroupBriefId,
                    adGroupIds = adGroupBriefs[0].adGroupIds
                )
                grutApiService.adGroupBriefGrutApi.createOrUpdateAdGroupBrief(adGroupBriefGrutModel)
            } else {
                logger.info("Found more then one existing ad group briefs by campaign " +
                    "$campaignId: ${adGroupBriefs.map { it.id }}")
            }
        }

        return fullyUpdatedUacYdbCampaign
    }

    override fun setDirectCampaignStatusToCreated(
        ydbCampaign: UacYdbCampaign,
        operator: User,
        subjectUser: User,
        changes: KtModelChanges<String, UacYdbCampaign>,
    ): Boolean {
        changes.process(UacYdbCampaign::directCampaignStatus, DirectCampaignStatus.CREATED)
        return true
    }

    override fun recreateCampaignInDirect(
        updatedUacYdbCampaign: UacYdbCampaign,
        directCampaignId: Long,
        operator: User,
        clientId: ClientId,
        operatorUid: Long
    ): Result<*> {
        throw IllegalStateException("This method must not be called in GrUT service implementation")
    }
}
