package ru.yandex.direct.web.entity.uac.service

import org.slf4j.Logger
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService
import ru.yandex.direct.core.entity.client.service.ClientGeoService
import ru.yandex.direct.core.entity.client.service.ClientLimitsService
import ru.yandex.direct.core.entity.client.service.ClientService
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.core.entity.feed.service.FeedService
import ru.yandex.direct.core.entity.image.repository.BannerImageFormatRepository
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterStorage
import ru.yandex.direct.core.entity.retargeting.service.validation2.AddRetargetingConditionValidationService2
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository
import ru.yandex.direct.core.entity.uac.model.DirectCampaignStatus
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbCampaignRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbDirectCampaignRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbDirectCampaign
import ru.yandex.direct.core.entity.uac.service.AudienceSegmentsService
import ru.yandex.direct.core.entity.uac.service.CpmBannerCampaignService
import ru.yandex.direct.core.entity.uac.service.RmpCampaignService
import ru.yandex.direct.core.entity.uac.service.UacBannerService
import ru.yandex.direct.core.entity.uac.service.UacCampaignService
import ru.yandex.direct.core.entity.uac.service.UacCampaignsCoreService
import ru.yandex.direct.core.entity.uac.service.UacContentService
import ru.yandex.direct.core.entity.uac.service.UacDisabledDomainsService
import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.dbutil.model.UidAndClientId
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.grid.processing.service.campaign.uc.UcCampaignMutationService
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler
import ru.yandex.direct.model.KtModelChanges
import ru.yandex.direct.result.Result
import ru.yandex.direct.web.entity.uac.converter.UacMobileCampaignConverter
import ru.yandex.direct.web.entity.uac.model.PatchCampaignInternalRequest

@Service
class WebYdbUacCampaignUpdateService(
    uacBannerService: UacBannerService,
    uacCampaignsCoreService: UacCampaignsCoreService,
    clientService: ClientService,
    ucCampaignMutationService: UcCampaignMutationService,
    uacCampaignValidationService: UacCampaignValidationService,
    uacGoalsService: UacGoalsService,
    clientGeoService: ClientGeoService,
    cpmBannerCampaignService: CpmBannerCampaignService,
    uacAdjustmentsUpdateService: UacAdjustmentsService,
    uacContentService: UacContentService,
    uacPropertiesService: UacPropertiesService,
    baseUacCampaignService: UacCampaignService,
    private val featureService: FeatureService,
    private val rmpCampaignService: RmpCampaignService,
    private val uacModifyCampaignDataContainerFactory: UacModifyCampaignDataContainerFactory,
    private val uacYdbDirectCampaignRepository: UacYdbDirectCampaignRepository,
    private val uacCampaignContentUpdateService: UacCampaignContentUpdateService,
    private val uacYdbCampaignRepository: UacYdbCampaignRepository,
    private val uacMobileAppService: UacMobileAppService,
    private val uacCampaignAddService: YdbUacCampaignAddService,
    private val sspPlatformsRepository: SspPlatformsRepository,
    private val hostingsHandler: HostingsHandler,
    private val bannerImageFormatRepository: BannerImageFormatRepository,
    private val shardHelper: ShardHelper,
    private val cpmBannerService: UacCpmBannerService,
    private val clientLimitsService: ClientLimitsService,
    private val disableDomainValidationService: DisableDomainValidationService,
    private val strategyValidatorFactory: RmpStrategyValidatorFactory,
    private val uacDisabledDomainsService: UacDisabledDomainsService,
    retargetingConditionValidationService: AddRetargetingConditionValidationService2,
    audienceSegmentsService: AudienceSegmentsService,
    feedService: FeedService,
    filterSchemaStorage: PerformanceFilterStorage,
) : WebBaseUacCampaignUpdateService(
    uacBannerService,
    uacMobileAppService,
    uacModifyCampaignDataContainerFactory,
    rmpCampaignService,
    uacCampaignsCoreService,
    clientService,
    ucCampaignMutationService,
    uacCampaignValidationService,
    uacGoalsService,
    clientGeoService,
    cpmBannerCampaignService,
    uacAdjustmentsUpdateService,
    uacContentService,
    uacPropertiesService,
    baseUacCampaignService,
    sspPlatformsRepository,
    hostingsHandler,
    bannerImageFormatRepository,
    shardHelper,
    cpmBannerService,
    clientLimitsService,
    disableDomainValidationService,
    strategyValidatorFactory,
    featureService,
    retargetingConditionValidationService,
    audienceSegmentsService,
    feedService,
    filterSchemaStorage,
) {

    companion object {
        private val logger = LoggerFactory.getLogger(WebYdbUacCampaignUpdateService::class.java)
    }

    override fun getLogger(): Logger = logger

    override fun updateBrief(
        updatedUacYdbCampaign: UacYdbCampaign,
        request: PatchCampaignInternalRequest,
        clientId: ClientId,
        multipleAdsInUc: Boolean,
    ): UacYdbCampaign {
        uacYdbCampaignRepository.updateCampaign(updatedUacYdbCampaign)
        uacCampaignContentUpdateService.updateCampaignContents(updatedUacYdbCampaign, request, multipleAdsInUc)

        return updatedUacYdbCampaign
    }

    override fun setDirectCampaignStatusToCreated(
            ydbCampaign: UacYdbCampaign,
            operator: User,
            subjectUser: User,
            changes: KtModelChanges<String, UacYdbCampaign>,
    ): Boolean {
        val directCampaign = uacYdbDirectCampaignRepository.getDirectCampaignById(ydbCampaign.id)
        val directCampaignId = directCampaign?.id
            ?: (uacCampaignAddService.createMissingMobileContentCampaign(
                operator, subjectUser,
                uacModifyCampaignDataContainerFactory.dataContainerFromUacYdbCampaign(ydbCampaign)
            )
                ?: return false)

        val directCampaignModelChanges: KtModelChanges<String, UacYdbDirectCampaign> =
            KtModelChanges(directCampaignId)
        directCampaignModelChanges.process(UacYdbDirectCampaign::status, DirectCampaignStatus.CREATED)
        uacYdbDirectCampaignRepository.update(directCampaignModelChanges)
        return true
    }

    override fun recreateCampaignInDirect(
        updatedUacYdbCampaign: UacYdbCampaign,
        directCampaignId: Long,
        operator: User,
        clientId: ClientId,
        operatorUid: Long,
    ): Result<*> {
        assert(updatedUacYdbCampaign.isDraft)

        val deleteResult = rmpCampaignService.deleteCampaign(clientId, operatorUid, directCampaignId)

        if (!deleteResult.isSuccessful) {
            return deleteResult
        }

        val appInfo = uacMobileAppService.getAppInfo(updatedUacYdbCampaign.appId)
        val trackingUrl = uacMobileAppService.getTrackingUrl(updatedUacYdbCampaign.trackingUrl, appInfo)
        val impressionUrl = uacMobileAppService.getImpressionUrl(updatedUacYdbCampaign.impressionUrl, appInfo)
        val mobileApp = UacMobileCampaignConverter.toMobileApp(appInfo!!, trackingUrl, impressionUrl)
        val disabledDomains = uacDisabledDomainsService.getDisabledDomains(
            updatedUacYdbCampaign.uacDisabledPlaces?.disabledPlaces.orEmpty()
        )

        val mobileContentCampaign = UacMobileCampaignConverter.toMobileContentCampaign(
            uacModifyCampaignDataContainerFactory.dataContainerFromUacYdbCampaign(
                updatedUacYdbCampaign,
                appInfo, trackingUrl, impressionUrl
            ),
            operator,
            featureService.getEnabledForClientId(operator.clientId),
            disabledDomains
        )
        val addResult = rmpCampaignService.addRmpCampaign(
            operator, UidAndClientId.of(operatorUid, clientId),
            mobileContentCampaign, mobileApp
        )

        if (!addResult.isSuccessful) {
            return addResult
        }

        uacYdbDirectCampaignRepository.updateDirectCampaignId(
            id = updatedUacYdbCampaign.id,
            directCampaignId = addResult.result!!.id
        )

        return addResult
    }
}
