package ru.yandex.direct.web.entity.uac.service

import com.google.common.base.Preconditions.checkState
import org.slf4j.LoggerFactory
import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService
import ru.yandex.direct.core.entity.campaign.service.CampaignService
import ru.yandex.direct.core.entity.campaign.service.uc.UcCampaignService
import ru.yandex.direct.core.entity.campaign.service.validation.DisableDomainValidationService
import ru.yandex.direct.core.entity.client.service.ClientGeoService
import ru.yandex.direct.core.entity.client.service.ClientLimitsService
import ru.yandex.direct.core.entity.client.service.ClientService
import ru.yandex.direct.core.entity.feature.service.FeatureService
import ru.yandex.direct.core.entity.feed.service.FeedService
import ru.yandex.direct.core.entity.image.repository.BannerImageFormatRepository
import ru.yandex.direct.core.entity.performancefilter.service.PerformanceFilterStorage
import ru.yandex.direct.core.entity.retargeting.service.uc.UcRetargetingConditionService
import ru.yandex.direct.core.entity.retargeting.service.validation2.AddRetargetingConditionValidationService2
import ru.yandex.direct.core.entity.sspplatform.repository.SspPlatformsRepository
import ru.yandex.direct.core.entity.uac.converter.UacContentConverter.toCampaignContents
import ru.yandex.direct.core.entity.uac.converter.UacContentConverter.toCampaignSitelinkContent
import ru.yandex.direct.core.entity.uac.converter.UacContentConverter.toCampaignTextContents
import ru.yandex.direct.core.entity.uac.grut.GrutTransactionProvider
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.CampaignStatuses
import ru.yandex.direct.core.entity.uac.model.Content
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbCampaignContentRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbCampaignRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.UacYdbDirectCampaignRepository
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbDirectCampaign
import ru.yandex.direct.core.entity.uac.service.CpmBannerCampaignService
import ru.yandex.direct.core.entity.uac.service.RmpCampaignService
import ru.yandex.direct.core.entity.uac.service.UacCampaignService
import ru.yandex.direct.core.entity.uac.service.UacContentService
import ru.yandex.direct.core.entity.uac.service.UacDisabledDomainsService
import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.grid.processing.service.campaign.uc.UcCampaignMutationService
import ru.yandex.direct.libs.mirrortools.utils.HostingsHandler
import ru.yandex.direct.result.Result
import ru.yandex.direct.web.entity.uac.converter.UacCampaignConverter.toUacYdbCampaign
import ru.yandex.direct.web.entity.uac.converter.UacCampaignConverter.toUacYdbDirectCampaign
import ru.yandex.direct.web.entity.uac.model.UacCampaign
import ru.yandex.direct.web.entity.uac.model.UacModifyCampaignDataContainer

@Service
class YdbUacCampaignAddService(
    uacModifyCampaignDataContainerFactory: UacModifyCampaignDataContainerFactory,
    rmpCampaignService: RmpCampaignService,
    cpmBannerCampaignService: CpmBannerCampaignService,
    ucCampaignMutationService: UcCampaignMutationService,
    ucRetargetingConditionService: UcRetargetingConditionService,
    uacGoalsService: UacGoalsService,
    ucCampaignService: UcCampaignService,
    clientGeoService: ClientGeoService,
    uacCampaignValidationService: UacCampaignValidationService,
    featureService: FeatureService,
    uacMobileAppService: UacMobileAppService,
    bidModifierService: BidModifierService,
    uacPropertiesService: UacPropertiesService,
    clientService: ClientService,
    uacAdjustmentsService: UacAdjustmentsService,
    campaignService: CampaignService,
    grutTransactionProvider: GrutTransactionProvider,
    private val uacYdbCampaignRepository: UacYdbCampaignRepository,
    private val uacYdbDirectCampaignRepository: UacYdbDirectCampaignRepository,
    private val uacYdbCampaignContentRepository: UacYdbCampaignContentRepository,
    private val uacCampaignService: UacCampaignService,
    private val ydbUacCampaignWebService: YdbUacCampaignWebService,
    private val uacContentService: UacContentService,
    private val sspPlatformsRepository: SspPlatformsRepository,
    private val hostingsHandler: HostingsHandler,
    private val bannerImageFormatRepository: BannerImageFormatRepository,
    private val shardHelper: ShardHelper,
    private val cpmBannerService: UacCpmBannerService,
    private val clientLimitsService: ClientLimitsService,
    private val disableDomainValidationService: DisableDomainValidationService,
    private val rmpStrategyValidatorFactory: RmpStrategyValidatorFactory,
    private val uacDisabledDomainsService: UacDisabledDomainsService,
    retargetingConditionValidationService: AddRetargetingConditionValidationService2,
    feedService: FeedService,
    filterSchemaStorage: PerformanceFilterStorage,
) : BaseUacCampaignAddService(
    uacMobileAppService,
    uacModifyCampaignDataContainerFactory,
    rmpCampaignService,
    cpmBannerCampaignService,
    ucCampaignMutationService,
    ucRetargetingConditionService,
    uacGoalsService,
    ucCampaignService,
    clientGeoService,
    uacCampaignValidationService,
    featureService,
    bidModifierService,
    uacPropertiesService,
    clientService,
    sspPlatformsRepository,
    hostingsHandler,
    bannerImageFormatRepository,
    shardHelper,
    cpmBannerService,
    clientLimitsService,
    disableDomainValidationService,
    uacAdjustmentsService,
    rmpStrategyValidatorFactory,
    uacDisabledDomainsService,
    retargetingConditionValidationService,
    uacCampaignService,
    campaignService,
    grutTransactionProvider,
    feedService,
    filterSchemaStorage
) {

    companion object {
        private val logger = LoggerFactory.getLogger(YdbUacCampaignAddService::class.java)
    }

    override fun getLogger() = logger

    override fun saveBrief(
        directCampaignId: Long,
        operator: User,
        subjectUser: User,
        createDataContainer: UacModifyCampaignDataContainer,
        contents: Collection<Content>,
        campaignStatuses: CampaignStatuses,
    ): UacCampaign {
        val campaignId = createDataContainer.id
        val directCampaign = saveDirectCampaign(campaignId, directCampaignId)
        val accountId = uacCampaignService.getOrCreateClient(operator = operator, subjectUser = subjectUser)
        val uacYdbCampaign = saveCampaign(createDataContainer, accountId)
        logger.info("Saved campaign $uacYdbCampaign")

        val ydbContents = toCampaignContents(campaignId, contents)
        val ydbTextContents = createDataContainer.texts?.let { toCampaignTextContents(campaignId, it, MediaType.TEXT) }
        val ydbTitleContents = createDataContainer.titles?.let { toCampaignTextContents(campaignId, it, MediaType.TITLE) }
        val ydbSitelinkContents = toCampaignSitelinkContent(campaignId, createDataContainer.sitelinks)

        val allYdbContents = listOfNotNull(ydbContents, ydbTextContents, ydbTitleContents, ydbSitelinkContents).flatten()

        uacYdbCampaignContentRepository.addCampaignContents(allYdbContents)
        logger.info("Contents: $allYdbContents")

        return ydbUacCampaignWebService.fillCampaign(
            operator = operator,
            subjectUser = subjectUser,
            uacYdbCampaign,
            directCampaign.directCampaignId,
            campaignStatuses,
        )
    }

    //создаёт кампанию директовую рмп-кампанию
    //предположительно legacy-код для старого асинхронного создания кампаний
    //Возвращает direct_campaigns.id в случае успешного создания
    fun createMissingMobileContentCampaign(
        operator: User,
        subjectUser: User,
        createDataContainer: UacModifyCampaignDataContainer
    ): String? {
        checkState(
            createDataContainer.advType == AdvType.MOBILE_CONTENT,
            "only old legacy mobile content camps expected"
        )
        val mobileContentCampaign = createMobileContentCampaignAndSaveToYdb(
            operator,
            subjectUser,
            createDataContainer
        )
        if (mobileContentCampaign.validationResult?.hasAnyErrors() == true ||
            mobileContentCampaign.result == null
        ) {
            return null
        }
        val directCampaign = mobileContentCampaign.result
        logger.info("Mobile content campaign: $directCampaign")
        return directCampaign.id
    }

    private fun createMobileContentCampaignAndSaveToYdb(
        operator: User,
        subjectUser: User,
        createDataContainer: UacModifyCampaignDataContainer,
    ): Result<UacYdbDirectCampaign> {
        val mobileContentCampaign = addMobileContentCampaign(operator, subjectUser, createDataContainer)
        if (!mobileContentCampaign.isSuccessful) {
            return Result.broken(mobileContentCampaign.validationResult)
        }
        val directCampaign = saveDirectCampaign(createDataContainer.id, mobileContentCampaign.result!!)
        return Result.successful(directCampaign)
    }

    private fun saveDirectCampaign(campaignId: String, directCampaignId: Long): UacYdbDirectCampaign {
        val directCampaign = toUacYdbDirectCampaign(campaignId, directCampaignId)
        uacYdbDirectCampaignRepository.saveDirectCampaign(directCampaign)
        return directCampaign
    }

    private fun saveCampaign(
        modifyCampaignDataContainer: UacModifyCampaignDataContainer,
        accountId: String,
    ): UacYdbCampaign {
        val ydbCampaign = toUacYdbCampaign(modifyCampaignDataContainer, accountId)
        uacYdbCampaignRepository.addCampaign(ydbCampaign)
        return ydbCampaign
    }

    override fun getContents(contentIds: Collection<String>): List<Content> {
        return uacContentService.getContents(contentIds)
    }
}
