package ru.yandex.direct.web.entity.uac.service

import org.springframework.stereotype.Service
import ru.yandex.direct.core.aggregatedstatuses.AggregatedStatusesService
import ru.yandex.direct.core.entity.bidmodifiers.service.BidModifierService
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository
import ru.yandex.direct.core.entity.campaign.service.CampaignBudgetReachService
import ru.yandex.direct.core.entity.client.service.ClientGeoService
import ru.yandex.direct.core.entity.feed.service.FeedService
import ru.yandex.direct.core.entity.hypergeo.service.HyperGeoService
import ru.yandex.direct.core.entity.uac.service.FetchedContents
import ru.yandex.direct.core.entity.uac.service.RmpCampaignService
import ru.yandex.direct.core.entity.uac.service.UacCampaignService
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.grid.processing.service.campaign.CampaignAgencyManagerInfoHelper
import ru.yandex.direct.grid.processing.service.campaign.CampaignInfoService
import ru.yandex.direct.grid.processing.service.client.ClientDataService

@Service
class YdbUacCampaignWebService(
    campaignAgencyManagerInfoHelper: CampaignAgencyManagerInfoHelper,
    campaignInfoService: CampaignInfoService,
    clientGeoService: ClientGeoService,
    shardHelper: ShardHelper,
    campaignRepository: CampaignRepository,
    hyperGeoService: HyperGeoService,
    rmpCampaignService: RmpCampaignService,
    uacMobileAppService: UacMobileAppService,
    aggregatedStatusesService: AggregatedStatusesService,
    bidModifierService: BidModifierService,
    private val ydbUacCampaignService: UacCampaignService,
    campaignBudgetReachService: CampaignBudgetReachService,
    uacRetargetingConditionService: UacRetargetingConditionService,
    clientDataService: ClientDataService,
    feedService: FeedService
) : BaseUacCampaignWebService(
    campaignAgencyManagerInfoHelper,
    campaignInfoService,
    clientGeoService,
    shardHelper,
    campaignRepository,
    hyperGeoService,
    rmpCampaignService,
    uacMobileAppService,
    aggregatedStatusesService,
    campaignBudgetReachService,
    bidModifierService,
    uacRetargetingConditionService,
    clientDataService,
    feedService
) {
    override fun getMinBannerIdForCampaign(id: String) = ydbUacCampaignService.getMinBannerIdForCampaign(id)
    override fun fetchContents(campaign: CampaignContainer): FetchedContents {
        when (campaign) {
            is CampaignContainer.Kt -> return ydbUacCampaignService.fetchContents(campaign.value)
            else -> throw IllegalStateException()
        }
    }
}
