package ru.yandex.direct.web.entity.uac.service

import org.springframework.http.ResponseEntity
import org.springframework.stereotype.Service
import org.springframework.web.multipart.MultipartFile
import ru.yandex.direct.core.entity.uac.model.AdvType
import ru.yandex.direct.core.entity.uac.model.Content
import ru.yandex.direct.core.entity.uac.model.CreativeType
import ru.yandex.direct.core.entity.uac.model.MediaType
import ru.yandex.direct.core.entity.uac.model.UacStrategyPlatform.SEARCH
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbContent
import ru.yandex.direct.core.entity.uac.service.UacCampaignService
import ru.yandex.direct.core.entity.uac.service.UacContentService
import ru.yandex.direct.core.entity.user.model.User
import ru.yandex.direct.dbqueue.repository.DbQueueRepository
import ru.yandex.direct.dbutil.sharding.ShardHelper
import ru.yandex.direct.result.Result
import ru.yandex.direct.web.entity.uac.contentsEmptyResponse
import ru.yandex.direct.web.entity.uac.model.CreateContentRequest
import ru.yandex.direct.web.entity.uac.textsEmptyResponse
import ru.yandex.direct.web.entity.uac.titlesEmptyResponse
import ru.yandex.direct.web.validation.kernel.ValidationResultConversionService
import java.util.Locale

@Service
class YdbUacContentWebService(
    private val uacContentService: UacContentService,
    private val ydbUacCampaignService: UacCampaignService,
    private val ydbUacContentService: UacContentService,
    validationResultConversionService: ValidationResultConversionService,
    dbQueueRepository: DbQueueRepository,
    shardHelper: ShardHelper,
    uacImageContentUploader: UacImageContentUploader,
    uacVideoContentUploader: UacVideoContentUploader,
    uacHtml5ContentUploader: UacHtml5ContentUploader,
) : BaseUacContentWebService(uacImageContentUploader, uacVideoContentUploader, uacHtml5ContentUploader, validationResultConversionService, dbQueueRepository, shardHelper) {

    override fun checkCampaignIsCompleteForUpdateStatus(campaign: UacYdbCampaign): ResponseEntity<Any>? {
        val contentsContainer = uacContentService.getCampaignContentsContainer(campaign)
        val contents = uacContentService.getContents(contentsContainer.mediaContents.mapNotNull { it.contentId })

        if (campaign.advType == AdvType.MOBILE_CONTENT && contents.isNullOrEmpty()) {
            if (contents.isNullOrEmpty() && campaign.strategyPlatform != SEARCH) {
                return contentsEmptyResponse()
            }
            val isOnlyPlayableContents = contents.none { it.type != MediaType.HTML5 }
            if (!isOnlyPlayableContents && contentsContainer.textContents.isNullOrEmpty()) {
                return textsEmptyResponse()
            }
            if (!isOnlyPlayableContents && contentsContainer.titleContents.isNullOrEmpty()) {
                return titlesEmptyResponse()
            }
        }

        if (campaign.advType == AdvType.TEXT) {
            if (contentsContainer.textContents.isNullOrEmpty()) {
                return textsEmptyResponse()
            }
            if (contentsContainer.titleContents.isNullOrEmpty()) {
                return titlesEmptyResponse()
            }
        }

        return checkCampaignIsCompleteCommon(campaign)
    }

    override fun fillContent(ydbContent: UacYdbContent?): Content? {
        return ydbUacContentService.fillContent(ydbContent)
    }

    override fun insertContent(content: UacYdbContent) {
        ydbUacContentService.insertContent(content)
    }

    override fun uploadContent(
        operator: User,
        subjectUser: User,
        creativeType: CreativeType,
        multipartFile: MultipartFile?,
        createContentRequest: CreateContentRequest?,
        locale: Locale?
    ): Result<UacYdbContent> {
        val accountId = ydbUacCampaignService.getOrCreateClient(operator, subjectUser)

        return if (createContentRequest != null)
            uploadContentFromRequest(subjectUser, accountId, createContentRequest, creativeType, locale)
        else uploadContentFromFile(subjectUser, accountId, multipartFile!!, creativeType, locale, null)
    }
}
