package ru.yandex.direct.web.entity.uac.service.history

import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.model.GrutHistoryEventEntry
import ru.yandex.direct.web.entity.uac.model.history.GrutHistoryRecord
import ru.yandex.direct.web.entity.uac.service.history.parser.BaseGrutCampaignHistoryEventParser

@Component
class GrutCampaignHistoryEventReader(
    @Autowired private val campaignParsers: List<BaseGrutCampaignHistoryEventParser>
) {
    fun getTypedHistoryEvents(history: List<GrutHistoryEventEntry<UacYdbCampaign>>): List<GrutHistoryRecord> {
        val historyEvents = mutableListOf<GrutHistoryRecord>()
        val peekingIterator = NotDeletedGrutHistoryPeekingIterator(history.iterator())
        while (peekingIterator.hasNext()) {
            val currentEntry = peekingIterator.next()
            val nextEntry = if (peekingIterator.hasNext()) peekingIterator.peek() else null
            if (nextEntry != null) {
                campaignParsers.forEach {
                    val candidate = it.parse(currentEntry, nextEntry)
                    if (candidate != null) {
                        historyEvents.add(candidate)
                    }
                }
            }
        }
        return historyEvents
    }
}
