package ru.yandex.direct.web.entity.uac.service.history

import com.google.common.collect.PeekingIterator
import ru.yandex.direct.core.grut.model.GrutHistoryEventEntry
import ru.yandex.direct.core.grut.model.GrutHistoryEventType

/**
 * This type of peeking iterator allows you to look one entry ahead in a given entry sequence and
 * skips all entries that have status = DELETED (an entry status is not the part of the lookup index in GrUT,
 * therefore such entries cannot be eliminated on read without triggering full-scan process)
 */
class NotDeletedGrutHistoryPeekingIterator<T>(
    private val iterator: Iterator<GrutHistoryEventEntry<T>>
) : PeekingIterator<GrutHistoryEventEntry<T>> {
    private var peekEntry: GrutHistoryEventEntry<T>? = null

    override fun remove() {
        throw UnsupportedOperationException("Removal is not supported for this iterator")
    }

    override fun hasNext(): Boolean {
        if (peekEntry == null) {
            while (iterator.hasNext()) {
                peekEntry = iterator.next()
                if (peekEntry?.eventType != GrutHistoryEventType.ET_OBJECT_REMOVED) {
                    break
                }
                peekEntry = null
            }
        }
        return peekEntry != null
    }

    override fun next(): GrutHistoryEventEntry<T> {
        if (!hasNext()) throw NoSuchElementException()
        val result = peekEntry
        peekEntry = null
        return result!!
    }

    override fun peek(): GrutHistoryEventEntry<T>? {
        if (!hasNext()) throw NoSuchElementException()
        return peekEntry
    }
}
