package ru.yandex.direct.web.entity.uac.service.history

import org.springframework.stereotype.Service
import ru.yandex.direct.core.entity.uac.grut.GrutTransactionProvider
import ru.yandex.direct.core.entity.uac.service.GrutUacCampaignService
import ru.yandex.direct.core.grut.api.CampaignGrutHistoryApi
import ru.yandex.direct.result.Result
import ru.yandex.direct.web.entity.uac.model.history.UacCampaignHistory
import ru.yandex.grut.client.GrutClient

@Service
class UacCampaignHistoryService(
    private val grutCampaignHistoryEventReader: GrutCampaignHistoryEventReader,
    grutClient: GrutClient,
    grutTransactionProvider: GrutTransactionProvider,
    grutUacCampaignService: GrutUacCampaignService,
) {
    private val campaignGrutHistoryApi = CampaignGrutHistoryApi(
        grutClient,
        grutTransactionProvider,
        grutUacCampaignService
    )

    fun getHistory(
        id: Long,
        from: Long?,
        to: Long,
    ): Result<List<UacCampaignHistory>> {
        val campaignHistory = campaignGrutHistoryApi.getCampaignHistory(id, from, to)
        if (campaignHistory.hasAnyErrors()) {
            return Result.broken(campaignHistory)
        }
        val history = grutCampaignHistoryEventReader.getTypedHistoryEvents(campaignHistory.value)
            .map {
                UacCampaignHistory(
                    it.timestamp,
                    it.grutHistoryEvent.getType(),
                    it.grutHistoryEvent.getOld(),
                    it.grutHistoryEvent.getNew())
            }
        return Result.successful(history)
    }
}
