package ru.yandex.direct.web.entity.uac.service.history.parser

import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.model.GrutHistoryEventEntry
import ru.yandex.direct.web.entity.uac.model.history.GrutHistoryRecord
import ru.yandex.direct.web.entity.uac.model.history.event.GrutCampaignHistoryEvent

abstract class BaseGrutCampaignHistoryEventParser : GrutHistoryEventParser<UacYdbCampaign> {
    protected abstract fun generateEvent(historyEntry: GrutHistoryEventEntry<UacYdbCampaign>): Any?

    private fun checkCampaignHistoryEntryIntegrity(
        previousState: GrutHistoryEventEntry<UacYdbCampaign>,
        currentState: GrutHistoryEventEntry<UacYdbCampaign>
    ) {
        if (previousState.value.id != currentState.value.id) {
            throw IllegalArgumentException("History entry can only be build over " +
                "the different versions of the same entry. Expected campaignId ${previousState.value.id}," +
                " got ${currentState.value.id} for output category: ${getOutputCategory()}")
        }
    }

    override fun parse(
        previousState: GrutHistoryEventEntry<UacYdbCampaign>,
        currentState: GrutHistoryEventEntry<UacYdbCampaign>
    ): GrutHistoryRecord? {
        checkCampaignHistoryEntryIntegrity(previousState, currentState)
        val previousValue = generateEvent(previousState)
        val currentValue = generateEvent(currentState)

        return getHistory(
            previousValue,
            currentValue,
            previousState.value.account,
            previousState.value.id,
            currentState.timestamp
        )
    }

    private fun getHistory(
        previousValue: Any?,
        currentValue: Any?,
        clientId: String,
        campaignId: String,
        timestamp: Long
    ): GrutHistoryRecord? {
        val campaignHistoryEvent = GrutCampaignHistoryEvent(
            previousValue,
            currentValue,
            getOutputCategory(),
            clientId,
            campaignId
        )

        return if (stateChanged(campaignHistoryEvent.getOld(), campaignHistoryEvent.getNew())) {
            GrutHistoryRecord(timestamp, campaignHistoryEvent)
        } else null
    }

    private fun stateChanged(old: Any?, new: Any?): Boolean {
        if (old == null && new == null) return false

        return if (old is Collection<*> && new is Collection<*>) {
            !(old.size == new.size && old.containsAll(new) && new.containsAll(old))
        } else {
            old != new
        }
    }
}
