package ru.yandex.direct.web.entity.uac.service.history.parser

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.model.GrutHistoryEventEntry
import ru.yandex.direct.web.entity.uac.model.history.GrutHistoryOutputCategory
import ru.yandex.direct.web.entity.uac.model.history.event.GrutDemographicAdjustmentView

@Component
class DemographicAdjustmentHistoryEventParser : BaseGrutCampaignHistoryEventParser() {
    override fun generateEvent(historyEntry: GrutHistoryEventEntry<UacYdbCampaign>): Any {
        return historyEntry.value.adjustments
            ?.filter { it.age != null || it.gender != null }
            ?.map { GrutDemographicAdjustmentView(it.gender, it.age, it.percent) }
            ?: emptyList<GrutDemographicAdjustmentView>()
    }

    override fun getOutputCategory(): GrutHistoryOutputCategory =
        GrutHistoryOutputCategory.CAMPAIGN_DEMOGRAPHIC_ADJUSTMENT
}
