package ru.yandex.direct.web.entity.uac.service.history.parser

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.model.GrutHistoryEventEntry
import ru.yandex.direct.web.entity.uac.model.history.GrutHistoryOutputCategory
import ru.yandex.direct.web.entity.uac.model.history.event.GrutGoalView
import ru.yandex.direct.web.entity.uac.model.history.event.GrutStrategyDataView
import ru.yandex.direct.web.entity.uac.model.history.event.GrutStrategyOptionsHistoryView
import ru.yandex.direct.web.entity.uac.model.history.event.GrutStrategyView

@Component
class GrutStrategyOptionsHistoryEventParser : BaseGrutCampaignHistoryEventParser() {
    override fun generateEvent(historyEntry: GrutHistoryEventEntry<UacYdbCampaign>): Any {
        val campaign = historyEntry.value
        val goals = campaign.goals?.map { GrutGoalView(it.goalId, it.conversionValue) } ?: emptyList()
        val strategyData = campaign.strategy
            ?.let {
                GrutStrategyDataView(
                    it.uacStrategyData.budget,
                    it.uacStrategyData.autoProlongation,
                    it.uacStrategyData.avgCpm,
                    it.uacStrategyData.finishDate,
                    it.uacStrategyData.startDate,
                    it.uacStrategyData.sum,
                    it.uacStrategyData.avgCpv,
                    it.uacStrategyData.crr,
                    it.uacStrategyData.avgCpa,
                    it.uacStrategyData.avgCpi,
                    it.uacStrategyData.avgBid,
                    it.uacStrategyData.payForConversion
                )
            }
        val strategy = campaign.strategy
            ?.let { GrutStrategyView(it.uacStrategyName, strategyData!!) }
        return GrutStrategyOptionsHistoryView(
            strategy,
            goals,
            campaign.strategyPlatform,
            campaign.targetId,
            campaign.weekLimit,
            campaign.cpa
        )
    }

    override fun getOutputCategory(): GrutHistoryOutputCategory {
        return GrutHistoryOutputCategory.CAMPAIGN_STRATEGY_OPTIONS
    }
}
