package ru.yandex.direct.web.entity.uac.service.history.parser

import org.springframework.stereotype.Component
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacYdbCampaign
import ru.yandex.direct.core.grut.model.GrutHistoryEventEntry
import ru.yandex.direct.web.entity.uac.model.history.GrutHistoryOutputCategory
import ru.yandex.direct.web.entity.uac.model.history.event.GrutRegionalAdjustmentHistoryView

@Component
class RegionalAdjustmentHistoryEventParser : BaseGrutCampaignHistoryEventParser() {
    override fun generateEvent(historyEntry: GrutHistoryEventEntry<UacYdbCampaign>): Any {
        return historyEntry.value.adjustments
            ?.filterNot { it.region == null }
            ?.map { GrutRegionalAdjustmentHistoryView(it.region!!, it.regionName, it.percent) }
            ?: emptyList<GrutRegionalAdjustmentHistoryView>()
    }

    override fun getOutputCategory(): GrutHistoryOutputCategory = GrutHistoryOutputCategory.CAMPAIGN_REGIONAL_ADJUSTMENT
}
