package ru.yandex.direct.web.entity.uac.validation

data class AvatarsPathInfo(
    val namespace: String,
    val groupId: String,
    val name: String,
    val size: String,
) {
    companion object {
        @JvmStatic
        fun fromPath(path: String?): AvatarsPathInfo? {
            val pathItems = (path ?: return null).trim('/').split('/')
            if (pathItems.size != 4) {
                return null
            }
            return AvatarsPathInfo(
                namespace = pathItems[0],
                groupId = pathItems[1],
                name = pathItems[2],
                size = pathItems[3],
            )
        }
    }

}
