package ru.yandex.direct.web.entity.uac.validation

import ru.yandex.direct.core.entity.banner.model.ButtonAction
import ru.yandex.direct.core.entity.banner.service.validation.defects.BannerDefects
import ru.yandex.direct.core.entity.banner.type.href.BannerHrefValidator
import ru.yandex.direct.core.entity.uac.repository.ydb.model.CpmAssetButton
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacButtonAction
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.defect.CommonDefects.invalidValue
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class CpmAssetButtonValidator constructor(val allowedButtonActions: Set<ButtonAction>) : DefaultValidator<CpmAssetButton> {

    override fun apply(b: CpmAssetButton): ValidationResult<CpmAssetButton, Defect<*>> {
        return validateObject(b) {
            property(CpmAssetButton::href) {
                checkBy(BannerHrefValidator(), When.notNull())
            }

            property(CpmAssetButton::customText) {
                check(Constraint.fromPredicate({customText: String? -> customText.isNullOrBlank()}, invalidValue()))
            }

            property(CpmAssetButton::action) {
                check(
                    Constraint.fromPredicate(
                        { o: UacButtonAction? -> allowedButtonActions.contains(o?.toCoreButtonAction()) },
                        BannerDefects.unsupportedButtonAction()
                    )
                )
            }
        }
    }
}
