package ru.yandex.direct.web.entity.uac.validation;

import ru.yandex.direct.core.entity.uac.model.UacShowsFrequencyLimit
import ru.yandex.direct.validation.constraint.NumberConstraints.notGreaterThan
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class CpmImpressionLimitsValidator : DefaultValidator<UacShowsFrequencyLimit> {
    override fun apply(t: UacShowsFrequencyLimit): ValidationResult<UacShowsFrequencyLimit, Defect<*>> {
        return validateObject(t) {
            property(UacShowsFrequencyLimit::impressionRateCount) {
                check(notGreaterThan(1000))
            }
            property(UacShowsFrequencyLimit::impressionRateIntervalDays) {
                check(notGreaterThan(30))
            }
        }
    }
}
