package ru.yandex.direct.web.entity.uac.validation;

import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.validation.constraint.CollectionConstraints.notEmptyCollection
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class CpmRetargetingsConditionsValidator : DefaultValidator<UacRetargetingCondition> {
    override fun apply(t: UacRetargetingCondition): ValidationResult<UacRetargetingCondition, Defect<*>> {
        return validateObject(t) {
            property(UacRetargetingCondition::conditionRules) {
                check(notEmptyCollection())
            }
        }
    }
}
