package ru.yandex.direct.web.entity.uac.validation

import ru.yandex.direct.core.entity.uac.model.Socdem
import ru.yandex.direct.validation.builder.Constraint
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.defect.CommonDefects
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class CpmSocdemValidator : DefaultValidator<Socdem> {

    override fun apply(t: Socdem): ValidationResult<Socdem, Defect<*>> {
        return validateObject(t) {
            check(notNull())

            //Доход либо указан весь целиком либо нет
            check(Constraint.fromPredicate({ x: Socdem ->
                (x.incomeLower == null) == (x.incomeUpper == null)
            }, CommonDefects.inconsistentState()), When.notNull())

            //Нижние границы меньше верхних
            check(Constraint.fromPredicate({ x: Socdem ->
                (x.incomeLower == null) || (x.incomeLower?.order!! < x.incomeUpper?.order!!)
            }, CommonDefects.inconsistentState()), When.isValid())

            //Нижние границы меньше верхних
            check(Constraint.fromPredicate({
                    x: Socdem ->
                (x.ageLower.order < x.ageUpper.order)
            }, CommonDefects.inconsistentState()), When.isValid())
        }
    }
}
