package ru.yandex.direct.web.entity.uac.validation

import org.eclipse.jetty.util.StringUtil
import ru.yandex.direct.validation.result.Defect
import java.net.URI
import java.net.URISyntaxException

class UacAvatarsUrlValidator(
    private val correctNamespaces: List<String>?,
    private val correctSizes: List<String>?,
) {
    private val correctAuthorities = listOf("avatars.mds.yandex.net", "avatars.mdst.yandex.net")

    fun validate(url: String): Defect<Void>? {
        if (StringUtil.isBlank(url)) {
            return invalidAvatarsUrl()
        }
        val uri: URI = getURI(url) ?: return null

        if (!correctAuthorities.contains(uri.authority)) {
            return invalidAvatarsUrl()
        }

        val avatarsPathInfo = AvatarsPathInfo.fromPath(uri.path) ?: return invalidAvatarsUrl()

        if (correctNamespaces != null) {
            if (!correctNamespaces.map {"get-$it"}.contains(avatarsPathInfo.namespace)) {
                return invalidTypeOfAvatarsUrl()
            }
        }
        if (correctSizes != null) {
            if (!correctSizes.contains(avatarsPathInfo.size)) {
                return invalidTypeOfAvatarsUrl()
            }
        }
        return null
    }

    private fun getURI(url: String): URI? {
        val trimmedUrl = url.trim().trim('"')

        try {
            val uri = URI(trimmedUrl)
            if (uri.scheme == null) {
               return URI("http://$trimmedUrl")
            }
            return uri
        } catch (e: URISyntaxException) {
            return null
        }
    }
}
