package ru.yandex.direct.web.entity.uac.validation

import java.math.BigDecimal
import ru.yandex.direct.core.entity.uac.model.UacGoal
import ru.yandex.direct.validation.builder.When
import ru.yandex.direct.validation.constraint.CollectionConstraints.listSize
import ru.yandex.direct.validation.constraint.CollectionConstraints.minListSize
import ru.yandex.direct.validation.constraint.CommonConstraints.isNull
import ru.yandex.direct.validation.constraint.CommonConstraints.notNull
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.property
import ru.yandex.direct.validation.util.validateList
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class UacGoalsValidator(
    private val cpa: BigDecimal?,
    private val crr: Long?
) : DefaultValidator<List<UacGoal>> {
    override fun apply(goals: List<UacGoal>?): ValidationResult<List<UacGoal>, Defect<*>> {
        val hasGoalWithCpa = goals.orEmpty().any { it.cpa != null }
        return validateList(goals) {
            check(notNull(), When.isTrue(cpa != null || crr != null))
            check(listSize(1, 1), When.isTrue(cpa != null))
            check(minListSize(1), When.isTrue(crr != null))
            checkEachBy { goal -> validateGoal(goal, hasGoalWithCpa) }
        }
    }

    private fun validateGoal(goal: UacGoal, hasGoalWithCpa: Boolean) = validateObject(goal) {
        property(UacGoal::conversionValue) {
            // TODO(DIRECT-172326)
            //check(isNull(), When.isTrue(cpa != null))
            check(isNull(), When.isTrue(goal.cpa != null))
        }
        property(UacGoal::cpa) {
            check(isNull(), When.isTrue(cpa != null))
            check(isNull(), When.isTrue(goal.conversionValue != null))
            check(notNull(), When.isTrue(cpa == null && crr == null && hasGoalWithCpa))
        }
    }
}
