package ru.yandex.direct.web.entity.uac.validation

import ru.yandex.direct.core.entity.uac.model.UacRetargetingConditionRule
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.listProperty
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class UacRetargetingConditionRuleValidator(
    private val existingGoalIds: Map<Long, String>,
    private val availableAudienceGoalIds: Set<Long>,
    private val existingMetrikaSegmentIds: Set<Long>,
) : DefaultValidator<UacRetargetingConditionRule> {
    override fun apply(rule: UacRetargetingConditionRule): ValidationResult<UacRetargetingConditionRule, Defect<*>> {
        return validateObject(rule) {
            listProperty(UacRetargetingConditionRule::goals) {
                checkEachBy(
                    UacRetargetingConditionRuleGoalValidator(
                        existingGoalIds,
                        availableAudienceGoalIds,
                        existingMetrikaSegmentIds
                    )
                )
            }
        }
    }
}
