package ru.yandex.direct.web.entity.uac.validation

import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.SEARCH_LIFT_BRANDS_MAX_SIZE
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.SEARCH_LIFT_OBJECTS_MAX_SIZE
import ru.yandex.direct.core.entity.campaign.service.validation.CampaignConstants.SEARCH_LIFT_UNIT_MAX_LENGTH
import ru.yandex.direct.core.entity.uac.repository.ydb.model.UacSearchLift
import ru.yandex.direct.validation.constraint.CollectionConstraints.maxListSize
import ru.yandex.direct.validation.constraint.StringConstraints.maxStringLength
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.util.listProperty
import ru.yandex.direct.validation.util.validateObject
import ru.yandex.direct.validation.wrapper.DefaultValidator

class UacSearchLiftValidator : DefaultValidator<UacSearchLift> {

    override fun apply(t: UacSearchLift): ValidationResult<UacSearchLift, Defect<*>> {
        return validateObject(t) {
            listProperty(UacSearchLift::brands) {
                check(maxListSize(SEARCH_LIFT_BRANDS_MAX_SIZE))
                checkEach(maxStringLength(SEARCH_LIFT_UNIT_MAX_LENGTH))
            }
            listProperty(UacSearchLift::searchObjects) {
                check(maxListSize(SEARCH_LIFT_OBJECTS_MAX_SIZE))
                checkEach(maxStringLength(SEARCH_LIFT_UNIT_MAX_LENGTH))
            }
        }

    }
}
