package ru.yandex.direct.web.entity.uac.validation

import ru.yandex.direct.core.entity.retargeting.service.validation2.AddRetargetingConditionValidationService2
import ru.yandex.direct.core.entity.uac.model.UacRetargetingCondition
import ru.yandex.direct.core.entity.uac.service.UacRetargetingService
import ru.yandex.direct.dbutil.model.ClientId
import ru.yandex.direct.validation.result.Defect
import ru.yandex.direct.validation.result.ValidationResult
import ru.yandex.direct.validation.result.ValidationResultUtils
import ru.yandex.direct.validation.util.ValidationUtils
import ru.yandex.direct.validation.wrapper.DefaultValidator

class UcRetargetingConditionValidator(
    private val retargetingConditionValidationService: AddRetargetingConditionValidationService2,
    private val clientId: ClientId,
) : DefaultValidator<UacRetargetingCondition> {

    override fun apply(uacRetargetingCondition: UacRetargetingCondition): ValidationResult<UacRetargetingCondition, Defect<*>> {
        val retargetingCondition = UacRetargetingService.toCoreRetargetingCondition(uacRetargetingCondition, clientId.asLong())

        val validationResults = retargetingConditionValidationService.validate(listOf(retargetingCondition), clientId)
        return ValidationUtils.convertToValidationResult(
            ValidationResultUtils.splitValidationResult(listOf(retargetingCondition), validationResults)[0],
            uacRetargetingCondition
        )
    }
}
