package ru.yandex.direct.web.entity.user.controller;

import javax.annotation.ParametersAreNonnullByDefault;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import ru.yandex.direct.core.security.DirectAuthentication;
import ru.yandex.direct.core.security.authorization.PreAuthorizeWrite;
import ru.yandex.direct.web.core.model.WebErrorResponse;
import ru.yandex.direct.web.core.model.WebResponse;
import ru.yandex.direct.web.core.security.DirectWebAuthenticationSource;
import ru.yandex.direct.web.entity.user.model.OfferAcceptedResponse;
import ru.yandex.direct.web.entity.user.service.WebUserService;

@Controller
@ParametersAreNonnullByDefault
@RequestMapping(value = "/user", produces = MediaType.APPLICATION_JSON_UTF8_VALUE)
@Api(tags = "user")
public class UserController {
    private final DirectWebAuthenticationSource authenticationSource;
    private final WebUserService webUserService;

    @Autowired
    public UserController(DirectWebAuthenticationSource authenticationSource, WebUserService webUserService) {
        this.authenticationSource = authenticationSource;
        this.webUserService = webUserService;
    }

    @ApiOperation(
            value = "setOfferAccepted",
            httpMethod = "POST",
            nickname = "setOfferAccepted"
    )
    @ApiResponses(
            {
                    @ApiResponse(code = 400, message = "Bad params", response = WebErrorResponse.class),
                    @ApiResponse(code = 403, message = "Permission denied", response = WebErrorResponse.class),
                    @ApiResponse(code = 200, message = "Ok", response = OfferAcceptedResponse.class)
            }
    )
    @PreAuthorizeWrite
    @PostMapping(
            path = "/set_offer_accepted",
            consumes = MediaType.APPLICATION_JSON_UTF8_VALUE
    )
    @ResponseBody
    public WebResponse setOfferAccepted() {
        DirectAuthentication auth = authenticationSource.getAuthentication();
        return webUserService.setOfferAccepted(auth);
    }
}
