package ru.yandex.direct.web.entity.user.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.web.entity.SuccessResponse

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class PublicFeature(
    val useKotlinForV1User: Boolean
)

@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy::class)
data class PublicFeatureResponse(
    val reqId: String,
) : SuccessResponse<PublicFeature>()

fun PublicFeature?.toResponse(): PublicFeatureResponse {
    val reqId = Trace.current().spanId.toString()
    return PublicFeatureResponse(reqId)
        .withResult(this)
}
