package ru.yandex.direct.web.entity.user.model

import com.fasterxml.jackson.databind.PropertyNamingStrategy.SnakeCaseStrategy
import com.fasterxml.jackson.databind.annotation.JsonNaming
import ru.yandex.direct.i18n.Language
import ru.yandex.direct.rbac.RbacRole
import ru.yandex.direct.tracing.Trace
import ru.yandex.direct.web.entity.SuccessResponse

@JsonNaming(SnakeCaseStrategy::class)
data class PublicOperatorInfo(
    val login: String,
    val avatarId: String,
    val isDirectUser: Boolean,
    var role: RbacRole,
    var isBlocked: Boolean,
    var lang: Language,
)

@JsonNaming(SnakeCaseStrategy::class)
data class PublicOperatorInfoResponse(
    val reqId: String,
) : SuccessResponse<PublicOperatorInfo>()

fun PublicOperatorInfo?.toResponse(): PublicOperatorInfoResponse {
    val reqId = Trace.current().spanId.toString()

    return PublicOperatorInfoResponse(reqId)
        .withResult(this)
}
