package ru.yandex.direct.web.entity.useractionlog;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

@ParametersAreNonnullByDefault
public class AdGroupView {
    private final Long id;
    private final String name;

    public AdGroupView(@Nullable Long id, String name) {
        this.id = id;
        this.name = name;
    }

    /**
     * Корректировки ставок могут иметь идентификатор группы, а могут и не иметь.
     * Поэтому позволяется null.
     */
    @Nullable
    public Long getId() {
        return id;
    }

    public @GraphQLNonNull
    String getName() {
        return name;
    }
}
