package ru.yandex.direct.web.entity.useractionlog;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;

import ru.yandex.direct.grid.model.campaign.GdCampaignSource;
import ru.yandex.direct.grid.model.campaign.GdCampaignType;

@ParametersAreNonnullByDefault
public class CampaignView {
    private final long id;
    private final String name;
    private final GdCampaignType type;
    private final GdCampaignSource source;
    private final CalcType calcType;

    public CampaignView(long id,
                        String name,
                        @Nullable GdCampaignType type,
                        @Nullable GdCampaignSource source,
                        CalcType calcType) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.source = source;
        this.calcType = calcType;
    }

    @GraphQLNonNull
    public long getId() {
        return id;
    }

    public @GraphQLNonNull
    String getName() {
        return name;
    }

    public @GraphQLNonNull
    CalcType getCalcType() {
        return calcType;
    }

    @Nullable
    public GdCampaignType getType() {
        return type;
    }

    @Nullable
    public GdCampaignSource getSource() {
        return source;
    }
}
