package ru.yandex.direct.web.entity.useractionlog;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.dataloader.DataLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.useractionlog.dict.DictRepository;
import ru.yandex.direct.useractionlog.dict.DictRequest;

@Component
@ParametersAreNonnullByDefault
// Обязательно должен иметь какой-нибудь Scope, не связанный с постоянно живущими синглтонами. Внутри DataLoader'ов
// встроен топорный вечный невытесняющий кеш, который, впрочем, полезен в пределах одного HTTP-запроса.
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class DictRepositoryDataLoader extends DataLoader<DictRequest, Optional<Object>> {
    @Autowired
    public DictRepositoryDataLoader(DictRepository readOnlyDictRepository) {
        super(dictRequests -> {
            Map<DictRequest, Object> result = readOnlyDictRepository.getData(dictRequests);
            return CompletableFuture.completedFuture(dictRequests.stream()
                    .map(result::get)
                    .map(Optional::ofNullable)
                    .collect(Collectors.toList()));
        });
    }
}
