package ru.yandex.direct.web.entity.useractionlog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.direct.useractionlog.dict.DictDataCategory;
import ru.yandex.direct.useractionlog.dict.DictRepository;
import ru.yandex.direct.useractionlog.dict.DictRequest;
import ru.yandex.direct.useractionlog.schema.ObjectPath;

/**
 * Ходит в словари пользовательских логов и получает из них ObjectPath для групп, баннеров.
 */
@ParametersAreNonnullByDefault
@Service
public class ObjectPathResolverService {
    private final DictRepository dictRepository;

    @Autowired
    public ObjectPathResolverService(DictRepository readOnlyDictRepository) {
        this.dictRepository = readOnlyDictRepository;
    }

    /**
     * Возвращает ObjectPath для указанных идентификаторов. Если для какого-то идентификатора ObjectPath не был найден
     * в словаре, то этот идентификатор игнорируется.
     */
    public Collection<ObjectPath> resolve(Collection<Long> adGroupIds, Collection<Long> adIds) {
        Collection<DictRequest> dictRequests = new ArrayList<>();
        for (long adGroupId : adGroupIds) {
            dictRequests.add(new DictRequest(DictDataCategory.ADGROUP_PATH, adGroupId));
        }
        for (long adId : adIds) {
            dictRequests.add(new DictRequest(DictDataCategory.AD_PATH, adId));
        }
        return dictRepository.getData(dictRequests).values().stream()
                .map(ObjectPath.class::cast)
                .collect(Collectors.toList());
    }
}
