package ru.yandex.direct.web.entity.useractionlog;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

import javax.annotation.ParametersAreNonnullByDefault;

import org.dataloader.DataLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;

import ru.yandex.direct.core.entity.timetarget.model.GeoTimezone;
import ru.yandex.direct.core.entity.timetarget.repository.GeoTimezoneRepository;

@Component
@ParametersAreNonnullByDefault
// Обязательно должен иметь какой-нибудь Scope, не связанный с постоянно живущими синглтонами. Внутри DataLoader'ов
// встроен топорный вечный невытесняющий кеш, который, впрочем, полезен в пределах одного HTTP-запроса.
@Scope(value = WebApplicationContext.SCOPE_REQUEST, proxyMode = ScopedProxyMode.TARGET_CLASS)
public class TimeZoneViewByIdDataLoader extends DataLoader<Long, TimeZoneView> {
    @Autowired
    public TimeZoneViewByIdDataLoader(GeoTimezoneRepository geoTimezoneRepository) {
        super(ids -> {
            Map<Long, TimeZoneView> result = ids.stream()
                    .map(i -> (long) i)
                    .collect(Collectors.collectingAndThen(Collectors.toSet(),
                            geoTimezoneRepository::getGeoTimezonesByTimezoneIds))
                    .stream()
                    .collect(Collectors.toMap(
                            GeoTimezone::getTimezoneId,
                            t -> new TimeZoneView(t.getTimezoneId(),
                                    t.getTimezone().getId())));
            return CompletableFuture.completedFuture(ids.stream()
                    .map(i -> result.getOrDefault((long) i, TimeZoneView.EMPTY))
                    .collect(Collectors.toList()));
        });
    }
}
