package ru.yandex.direct.web.entity.useractionlog;

import java.util.List;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

import io.leangen.graphql.annotations.GraphQLNonNull;
import io.leangen.graphql.annotations.types.GraphQLType;

import ru.yandex.direct.useractionlog.reader.UserActionLogOffset;
import ru.yandex.direct.useractionlog.reader.model.LogRecord;

@GraphQLType(name = "UserActionLogContext")
@ParametersAreNonnullByDefault
public class UserActionLogContext {
    private final List<LogRecord> logRecords;
    @Nullable
    private final String nextPageToken;

    public UserActionLogContext(List<LogRecord> logRecords, @Nullable UserActionLogOffset window) {
        this.logRecords = logRecords;
        this.nextPageToken = window != null ? window.toToken() : null;
    }

    public @GraphQLNonNull
    List<@GraphQLNonNull LogRecord> getLogRecords() {
        return logRecords;
    }

    @Nullable
    public String getNextPageToken() {
        return nextPageToken;
    }
}
